#todo=1
#MAX_PATH = 260
;-global
Global overwriteall
;-

Procedure FileTimeToDate(*FT.FileTime)
  st.systemtime
  FileTimeToSystemTime_(*ft,st)
  h=st\whour+1:  If h=24 : h=0: EndIf
  result=Date(st\wyear,st\wmonth,st\wday,h,st\wminute,st\wsecond)
  If h=0 : result+86400 : EndIf ; ein tag hochzhlen
  ProcedureReturn result
EndProcedure
Procedure DateToFileTime(datum,*ft.filetime)
  st.systemtime
  h=Hour(datum)-1:  If h=-1 : h=23:datum-86400 :EndIf ; ein Tag runterzhlen
  st\wyear=Year(datum):st\wmonth=Month(datum):st\wday=Day(datum):st\whour=H:st\wminute=Minute(datum):st\wsecond=Second(datum):st\wMilliseconds=0
  SystemTimeToFileTime_(st,*ft)
EndProcedure
Procedure SetFileTime(file$,datum)
  result=0
  openbuff.ofstruct
  openbuff\cbytes=SizeOf(ofstruct)
  handle=OpenFile_(@file$,@openbuff,#OF_READWRITE)
  If handle
    st.systemtime
    ft.filetime
    DateToFileTime(datum,ft)
    result=SetFileTime_(handle,0,0,ft)
    _lclose_(handle)
  EndIf
  ProcedureReturn result
EndProcedure
Procedure GetFileTime(file$)
  result=0
  openbuff.ofstruct
  openbuff\cbytes=SizeOf(ofstruct)
  handle=OpenFile_(@file$,@openbuff,#OF_READWRITE)
  If handle
    st.systemtime
    ft.filetime
    getfiletime_(handle,0,0,ft)
    result=FileTimeToDate(ft)
    _lclose_(handle)
  EndIf
  ProcedureReturn result
EndProcedure
Procedure ValHex(hexa$)
  ok=-1:dd=0:mi=0
  i=1
  result=0
  While ok=-1 And i<=Len(hexa$)
    c$=UCase(Mid(hexa$,i,1)):i+1
    Select c$
      Case "-"
        If mm
          ok=0
        Else
          mi=-2
        EndIf
      Case "$"
        If dd
          ok=0
        Else
          dd=-1:mi=-1
        EndIf
      Case "0":result=result<<4:dd=-1:mi=-1
      Case "1":result=result<<4+1:dd=-1:mi=-1
      Case "2":result=result<<4+2:dd=-1:mi=-1
      Case "3":result=result<<4+3:dd=-1:mi=-1
      Case "4":result=result<<4+4:dd=-1:mi=-1
      Case "5":result=result<<4+5:dd=-1:mi=-1
      Case "6":result=result<<4+6:dd=-1:mi=-1
      Case "7":result=result<<4+7:dd=-1:mi=-1
      Case "8":result=result<<4+8:dd=-1:mi=-1
      Case "9":result=result<<4+9:dd=-1:mi=-1
      Case "A":result=result<<4+10:dd=-1:mi=-1
      Case "B":result=result<<4+11:dd=-1:mi=-1
      Case "C":result=result<<4+12:dd=-1:mi=-1
      Case "D":result=result<<4+13:dd=-1:mi=-1
      Case "E":result=result<<4+14:dd=-1:mi=-1
      Case "F":result=result<<4+15:dd=-1:mi=-1
      Case " ":;nothing
      Default:ok=0
    EndSelect
  Wend
  If mi=-2 : result=-result :EndIf
  ProcedureReturn result
EndProcedure
;-
;-structure dirfile_data_
Structure dirfile_data_
  dwFileAttributes.l
  ftCreationTime.FILETIME
  ftLastAccessTime.FILETIME
  ftLastWriteTime.FILETIME
  nFileSizeHigh.l
  nFileSizeLow.l
  dwReserved0.l
  dwReserved1.l
  cFileName.b[ #MAX_PATH ]
  cAlternate.b[ 14 ]
  DontRead.l ;<- Das brau ich
EndStructure

Global dirfile_.dirfile_data_

Procedure isDirectoryEmpty(dir$)
  If Right(dir$,1)<>"\" : dir$+"\" : EndIf
  result=-1
  If ExamineDirectory(0,dir$,"*.*")
    While NextDirectoryEntry()<>0 And result=-1
      If Left(DirectoryEntryName(),1)<>"."
        result=0
      EndIf
    Wend
  Else
    result=0    
  EndIf
  ProcedureReturn result
EndProcedure
Procedure ExamineDir(file$)
  result = FindFirstFile_(@file$,@dirfile_)
  dirfile_\DontRead=1
  ProcedureReturn result
EndProcedure
Procedure StopDir(handle)
  FindClose_(handle)
EndProcedure  
Procedure NextDirEntry(handle)
  If dirfile_\DontRead=1
    Dirfile_\DontRead=0
    x=1
  Else
    x=findNextFile_(handle,@dirfile_)
  EndIf
  If x
    If dirfile_\dwFileAttributes&#FILE_ATTRIBUTE_DIRECTORY
      ProcedureReturn 2; verzeichnis
    Else
      ProcedureReturn 1; datei
    EndIf
  Else
    ProcedureReturn 0; ende
  EndIf
EndProcedure
Procedure.s DirEntryName()
  ProcedureReturn PeekS(@dirfile_\cFileName[0],#MAX_PATH )
EndProcedure
Procedure DirEntryAttributes()
  ProcedureReturn dirfile_\dwFileAttributes
EndProcedure
Procedure DirEntryLastWriteTime()
  ProcedureReturn FiletimeToDate(dirfile_\ftLastWritetime)
EndProcedure
Procedure DirEntrySize()
  ProcedureReturn (dirfile_\nFileSizeHigh<<16+dirfile_\nFileSizeLow)
EndProcedure

;-updater

NewList filelist$()
NewList directory$()
NewList removeFile$()
NewList rewriteFile$()
NewList createDirectory$()
NewList removeDirectory$()
NewList UpdateFile$()

Procedure Should_overwrite(file$,exDate,pckDate)
  result=3;default=nein
  If OpenWindow(2,0,0,400,195,#PB_Window_ScreenCentered,"Updater - Newer File ?")
    CreateGadgetList(WindowID(2))
    #top=5
    TextGadget(0, 10,#top, 380,20,"Found a newer File than in the Update",#PB_Text_Center):#top=#top+20
    TextGadget(0, 10,#top, 380,20,file$,#PB_Text_Center):#top=#top+20
    #top=#top+5
    TextGadget(0, 10,#top, 380,20,"Date of exist file:",#PB_Text_Center):#top=#top+20
    TextGadget(0, 10,#top, 380,20,FormatDate("%dd.%mm.%yyyy %hh:%ii:%ss",exDate),#PB_Text_Center):#top=#top+20
    #top=#top+5
    TextGadget(0, 10,#top, 380,20,"Date of update file:",#PB_Text_Center):#top=#top+20
    TextGadget(0, 10,#top, 380,20,FormatDate("%dd.%mm.%yyyy %hh:%ii:%ss",pckDate),#PB_Text_Center):#top=#top+20
    #top=#top+5
    TextGadget(0, 10,#top, 380,20,"Overwrite the file?",#PB_Text_Center):#top=#top+20
    #top=#top+5
    
    ButtonGadget(10, 10+(89+8)*0,#top, 89,25,"Yes")
    ButtonGadget(11, 10+(89+8)*1,#top, 89,25,"Yes, all")
    ButtonGadget(12, 10+(89+8)*2,#top, 89,25,"No")
    ButtonGadget(13, 10+(89+8)*3,#top, 89,25,"No, all"):#top=#top+25
    #top=#top+5
    ;Debug #top
    
    quit=0
    Repeat
      Select WaitWindowEvent()
        Case #PB_Event_CloseWindow
          If EventWindowID()=2: quit=1 :EndIf
        Case #pb_event_gadget
          If EventWindowID()=2 And EventGadgetID()>=10 And EventGadgetID()<=13
            result=EventGadgetID()-9
            quit=1
          EndIf
      EndSelect
    Until quit
    
    CloseWindow(2)
  EndIf
  ProcedureReturn result
EndProcedure
Procedure search_updatefile$()
  ClearList(updateFile$())
  handle=examinedir(".\*.update")
  If handle>0
    quit=0
    Repeat
      Select NextDirEntry(handle)
        Case 0:quit=-1
        Case 1
          ;datum=DirEntryLastWriteTime()
          file$=DirEntryName()
          ;                 123 456 78
          datum=ParseDate("%yy-%mm-%dd",Left(file$,8))
          ResetList(updatefile$())
          equit=-1
          While equit
            If NextElement(updatefile$())
              If Val(StringField(updatefile$(),2,"/"))>datum
                If PreviousElement(updatefile$())=0: ResetList(updatefile$()) :EndIf
                equit=0
              EndIf
            Else
              equit=0
            EndIf
          Wend
          AddElement(updatefile$())
          updatefile$()=file$+"/"+Str(datum)
      EndSelect
    Until quit
  EndIf
EndProcedure

Procedure update_readfilelist()
  ClearList(filelist$())
  ClearList(directory$())
  AddElement(directory$())
  directory$()=".\"
  
  While FirstElement(directory$())
    dir$=directory$()
    If Left(dir$,2)=".\" 
      ddir$=Mid(dir$,3,Len(dir$)) 
    Else
      ddir$=dir$
    EndIf
    DeleteElement(directory$())
    handle=ExamineDir(dir$+"*.*")
    If handle
      quit=0
      Repeat
        Select NextDirEntry(handle)
          Case 0:quit=1
          Case 1
            Select UCase(GetExtensionPart(DirEntryName()))
              Case "BMP":;bilder
              Case "PNG":;auch keine PNGs
              Case "GID":;nothing
              Case "PB":;nothing
              Case "PBI":;nothing
              Case "PBFL":;nothing
              Case "BAK":;nothing
              Case "ICO":;nothing
              Case "UPDATE":;nothing
              Default
                Select UCase(DirEntryName())
                  Case "CHARAS.UPDATER.EXE":;nothing
                  Case "UPDATELIST.INI":;nothing
                  Case "CHARAS.EX.INI":;nothing
                  Case "UPDATE_TODO.INI":;nothing
                  Case "UPDATE":;nothing
                  Default
                    AddElement(filelist$())
                    filelist$()=ddir$+DirEntryName()+"/"+Str(DirEntrySize())+"/"+Str(DirEntryLastWriteTime())
                EndSelect
            EndSelect
          Case 2
            If Left(DirEntryName(),1)<>"."
              AddElement(directory$())
              directory$()=dir$+DirEntryName()+"\"
              AddElement(filelist$())
              filelist$()=ddir$+DirEntryName()+"/0/0"
            EndIf
        EndSelect
      Until quit
      StopDir(handle)
    EndIf
  Wend
EndProcedure
Procedure update_savefilelist()
  DeleteFile("updatelist.ini.bak")
  RenameFile("updatelist.ini","updatelist.ini.bak")
  If CreateFile(1,"updatelist.ini")
    ResetList(filelist$())
    While NextElement(filelist$())
      If UCase(StringField(filelist$(),1,"/"))<>"CHARAS.UPDATER.EXE.NEW"
        WriteStringN(filelist$())
      EndIf
    Wend
    CloseFile(1)
  EndIf
EndProcedure
Procedure create_update()
  result=0
  
  SetGadgetText(3,"Read file list")
  update_readfilelist()
  AddGadgetItem(1,0,"File list readed.",UseImage(1))
  
  ClearList(removeFile$())
  ClearList(rewriteFile$())
  ClearList(createDirectory$())
  ClearList(removeDirectory$())
  
  If ReadFile(1,"updatelist.ini")
    SetGadgetText(3,"Check old files..")
    ;erstmal kontrollieren, ob die alten noch da sind.
    While Eof(1)=0
      entry$=ReadString()
      file$=StringField(entry$,1,"/"):size=Val(StringField(entry$,2,"/")):datum=Val(StringField(entry$,3,"/"))
      ResetList(filelist$())
      ok=0
      While NextElement(filelist$()) And ok=0
        If UCase(StringField(filelist$(),1,"/"))=UCase(file$) ; Name gefunden!
          If size=0 And datum=0
            ;eintrag ist ein Ordner
            ok=-1
          Else
            ;eintrag ist eine Datei
            If size<>Val(StringField(filelist$(),2,"/")) Or datum<>Val(StringField(filelist$(),3,"/"))
              AddElement(rewriteFile$())
              rewriteFile$()=StringField(filelist$(),1,"/")+"/"+StringField(filelist$(),3,"/")
              AddGadgetItem(1,0,"ToDo - Update file: "+StringField(filelist$(),1,"/")):WindowEvent()
            EndIf
            ok=-1
          EndIf
          DeleteElement(filelist$())
        EndIf
      Wend
      If ok=0
        ; alte Datei exestiert nicht mehr -> lschen
        If size=0 And datum=0
          ;eintrag=ordner und der mu rckwrts sortiert werden!
          ResetList(removeDirectory$())
          AddElement(removeDirectory$())
          removeDirectory$()=file$
          AddGadgetItem(1,0,"ToDo - Remove directory: "+file$):WindowEvent()
        Else
          AddElement(removeFile$())
          removeFile$()=file$
          AddGadgetItem(1,0,"ToDo - Delete file: "+file$):WindowEvent()
        EndIf        
      EndIf
    Wend
    CloseFile(1)
  Else
    AddGadgetItem(1,0,"Can't open updatelist.ini > update all",UseImage(0)):WindowEvent()
  EndIf
  
  ;so jetzt die neuen aufnehmen
  SetGadgetText(3,"Search for new files..")
  ResetList(filelist$())
  While NextElement(filelist$())
    file$=StringField(filelist$(),1,"/"):size=Val(StringField(filelist$(),2,"/")):datum=Val(StringField(filelist$(),3,"/"))
    If size=0 And datum=0
      ;Ordner erstellen
      AddElement(createDirectory$())
      createdirectory$()=file$
      AddGadgetItem(1,0,"ToDo - Create directory: "+file$):WindowEvent()
    Else
      ;eine datei
      AddElement(rewriteFile$())
      rewritefile$()=file$+"/"+Str(datum)
      AddGadgetItem(1,0,"ToDo - Create file: "+file$):WindowEvent()
    EndIf
  Wend
  
  If CountList(createDirectory$())>0 Or CountList(rewriteFile$())>0 Or CountList(removeFile$())>0 Or CountList(removeDirectory$())>0
    ;eine Hilfsdatei erzeugen
    If CreateFile(#1,"update_todo.ini")
      SetGadgetText(3,"Create: update_todo.ini")
      WriteStringN("/CreateDirectory")
      ResetList(createDirectory$())
      While NextElement(createDirectory$())
        WriteStringN(createdirectory$())
      Wend
      WriteStringN("/UpdateFiles")
      ResetList(rewriteFile$())
      While NextElement(rewriteFile$())
        WriteStringN(rewriteFile$())
      Wend
      WriteStringN("/DeleteFiles")
      ResetList(removeFile$())
      While NextElement(removeFile$())
        WriteStringN(removefile$())
      Wend
      WriteStringN("/RemoveDirecctory")
      ResetList(removeDirectory$())
      While NextElement(removeDirectory$())
        WriteStringN(removeDirectory$())
      Wend
      WriteStringN("/End")
      CloseFile(1)
      AddGadgetItem(1,0,"Create: update_todo.ini",UseImage(1)):WindowEvent()
      
      packfile$=FormatDate("%yy-%mm-%dd",Date())
      If CreatePack(packfile$+".update")
        SetGadgetText(3,"Add to "+packfile$+" update_todo.ini")
        AddPackFile("update_todo.ini",9)
        AddGadgetItem(1,0,"Pack file: update_todo.ini",UseImage(1)):WindowEvent()
        ResetList(rewriteFile$())
        While NextElement(rewriteFile$())
          file$=StringField(rewriteFile$(),1,"/")
          SetGadgetText(3,"Add to "+packfile$+" "+File$)
          AddPackFile(File$,9)
          AddGadgetItem(1,0,"Pack file: "+File$,UseImage(1)):WindowEvent()
        Wend
        ClosePack()
        
        l=FileSize(packfile$+".update")
        If l>0
          adr=AllocateMemory(0,l)
          If adr
            If OpenFile(0,packfile$+".update")
              ReadData(adr,l)
              CloseFile(0)
              crc=CRC32Fingerprint(adr,l)
              RenameFile(packfile$+".update",packfile$+" "+Hex(crc)+".update")
              AddGadgetItem(1,0,"CRC-Checksum:"+Hex(crc),UseImage(1))
            Else
              AddGadgetItem(1,0,"Can't create CRC-Checksum:file not found)",UseImage(0))
            EndIf
            FreeMemory(0)
          Else
            AddGadgetItem(1,0,"Can't create CRC-Checksum:out of memory",UseImage(0))
          EndIf
        Else
          AddGadgetItem(1,0,"Can't create CRC-Checksum:filesize<0",UseImage(0))
        EndIf
        
        
        SetGadgetText(3,"Create: updatelist.ini")
        update_readfilelist()
        update_savefilelist()
        AddGadgetItem(1,0,"Create: updatelist.ini",UseImage(1)):WindowEvent()
        
        SetGadgetText(3,"Update "+packfile$+" is created!")
      Else
        AddGadgetItem(1,0,"Can't create: "+packfile$,UseImage(0)):WindowEvent()
        SetGadgetText(3,"ERROR: Can't create: "+packfile$)
        result=-1
      EndIf
      
      DeleteFile("update_todo.ini")
      AddGadgetItem(1,0,"Delete: update_todo.ini",UseImage(1)):WindowEvent()
    Else
      AddGadgetItem(1,0,"Can't create: update_todo.ini",UseImage(0)):WindowEvent()
      SetGadgetText(3,"Can't create: update_todo.ini")
      result=-2  
    EndIf
  Else
    AddGadgetItem(1,0,"No Update needed!",UseImage(0)):WindowEvent()
    SetGadgetText(3,"No Update needed!")
    result=-3
  EndIf
 
  ProcedureReturn result
EndProcedure
Procedure do_update_help(name$)
  ;path erzeugen, falls nicht da
  path$=GetPathPart(name$)
  If path$<>""
    pos=1
    While pos
      pos=FindString(path$,"\",pos+1)
      CreateDirectory(Left(path$,pos))
    Wend
  EndIf
  
  adr=NextPackFile()
  If CreateFile(2,name$)
    WriteData(adr,PackFileSize())
    CloseFile(2)
    ProcedureReturn -1
  Else
    ProcedureReturn 0
  EndIf
EndProcedure
Procedure do_update(update$,defaultdate)
  result=0
  ; -1="update" nicht gefunden
  ok=0
  AddGadgetItem(1,0,"Updatefile: "+update$,UseImage(2))
  OpenTreeGadgetNode(1)
  
  ;erstmal ein CRC-Check.
  oldcrc=valhex(Mid(update$,10,8))
  If oldcrc
    l=FileSize(update$)
    If l>0
      adr=AllocateMemory(0,l)
      If adr
        If OpenFile(0,update$)
          ReadData(adr,l)
          CloseFile(0)
          crc=CRC32Fingerprint(adr,l)
          If crc=Oldcrc
            AddGadgetItem(1,0,"CRC-Checksum: OK",UseImage(1))
          Else
            AddGadgetItem(1,0,"CRC-Checksum-error:"+Hex(oldcrc)+"<>"+Hex(crc),UseImage(0))
            FreeMemory(0)
            CloseTreeGadgetNode(1)
            MessageRequester("Charas.Updater","CRC-Checksum-Error!"+Chr(13)+Hex(oldcrc)+"<>"+Hex(crc)+Chr(13)+"No Update!",0)
            ProcedureReturn -2
          EndIf
        Else
          AddGadgetItem(1,0,"CRC-Checksum:Can't open update",UseImage(0))
        EndIf
        FreeMemory(0)
      Else
        AddGadgetItem(1,0,"CRC-Checksum:out of memory",UseImage(0))
      EndIf
    Else        
      AddGadgetItem(1,0,"CRC-Checksum:filesize-error",UseImage(0))
    EndIf
  Else
    AddGadgetItem(1,0,"No CRC found",UseImage(0))
  EndIf
  
  If OpenPack(update$)
    do_update_help("update_todo.ini")
    ReadFile(1,"update_todo.ini")
    todo=-1
    While Eof(1)=0 And todo<>0
      UseFile(1):a$=ReadString()
      If Left(a$,2)=".\"
        a$=Mid(a$,3,Len(a$))
      EndIf
      
      If Left(a$,1)="/"
        Select LCase(a$)
          Case "/createdirectory":todo=1
          Case "/updatefiles":todo=2
          Case "/deletefiles":todo=3
          Case "/removedirecctory":todo=4
          Case "/end":todo=0
        EndSelect
      Else
        Select todo
          Case 1
            SetGadgetText(3,"Create directory: "+a$)
            CompilerIf #todo
              If CreateDirectory(a$)
                AddGadgetItem(1,0,"Create directory: "+a$,UseImage(1))
              Else
                AddGadgetItem(1,0,"Can't create directory: "+a$,UseImage(0))
              EndIf
            CompilerElse
              AddGadgetItem(1,0,"Create directory: "+a$,UseImage(1))
            CompilerEndIf
            WindowEvent()
          Case 2
            file$=StringField(a$,1,"/")
            datum=Val(StringField(a$,2,"/")):If datum=0: datum=defaultdate :EndIf
            ;Debug datum
            SetGadgetText(3,"Update file: "+file$)
            CompilerIf #todo
              write=-1
              exDate=GetFileTime(file$)
              If exDate>datum
                ;es exestiert bereits eine neuere Version (laut datum)
                Select overwriteall
                  Case 0
                    Select should_overwrite(file$,exDate,datum)
                      Case 1:write=-1
                      Case 2:write=-1:overwriteall=1
                      Case 3:write=0
                      Case 4:write=0:overwriteall=2
                    EndSelect
                  Case 1:write=-1
                  Case 2:write=0
                EndSelect
              EndIf
              If write
                If do_update_help(file$)
                  SetFileTime(file$,datum)
                  AddGadgetItem(1,0,"Update file: "+file$,UseImage(1))
                Else
                  AddGadgetItem(1,0,"Can't update file: "+file$,UseImage(0))
                EndIf
              Else
                NextPackFile(); auf jeden fall die datei entpacken!
                AddGadgetItem(1,0,"Don't update file: "+file$,UseImage(0))
              EndIf
            CompilerElse
              AddGadgetItem(1,0,"Update file: "+file$,UseImage(1))
            CompilerEndIf
            WindowEvent()
          Case 3
            SetGadgetText(3,"Delete file: "+a$)
            CompilerIf #todo
              If DeleteFile(a$)
                AddGadgetItem(1,0,"Delete file: "+a$,UseImage(1))
              Else
                AddGadgetItem(1,0,"Can't delete file: "+a$,UseImage(0))
              EndIf
            CompilerElse
              AddGadgetItem(1,0,"Delete file: "+a$,UseImage(1))
            CompilerEndIf
            WindowEvent()
          Case 4
            SetGadgetText(3,"Remove directory: "+a$)
            CompilerIf #todo
              If isDirectoryEmpty(a$)
                If DeleteDirectory(a$,"*.*")
                  AddGadgetItem(1,0,"Remove directory: "+a$,UseImage(1))
                Else
                  AddGadgetItem(1,0,"Can't remove directory: "+a$,UseImage(0))
                EndIf
              Else
                AddGadgetItem(1,0,"Don't remove directory: "+a$,UseImage(0))
              EndIf
            CompilerElse
              AddGadgetItem(1,0,"Remove directory: "+a$,UseImage(1))
            CompilerEndIf
            WindowEvent()
        EndSelect
      EndIf
    Wend
    CloseFile(1)
    DeleteFile("update_todo.ini")
    ClosePack()
  Else
    result=-1
  EndIf
  CloseTreeGadgetNode(1)
  ProcedureReturn result
EndProcedure

;-main

If OpenWindow(0,0,0,400,400,#PB_Window_SystemMenu|#PB_Window_ScreenCentered,"Updater")
  If CreateGadgetList(WindowID())
    CatchImage(0,?fehler)
    CatchImage(1,?ok)
    CatchImage(2,?leer)
    TreeGadget  (1,10, 10,380,325,#PB_Tree_NoLines)
    TextGadget  (3,10,340,380, 20,"",#PB_Text_Border)
    ButtonGadget(2,10,365,380, 25,"Exit")

    DisableGadget(2,1)

    If LCase(ProgramParameter())="start"
      autostart$=ProgramParameter()
      a$="Wait for end of "+autostart$+" "
      ok=-1
      openbuff.ofstruct
      openbuff\cbytes=SizeOf(ofstruct)
      While ok
        SetGadgetText(3,a$)
        handle=OpenFile_(@autostart$,@openbuff,#OF_SHARE_EXCLUSIVE)
        If handle>0
          _lclose_(handle)
          ok=0
        Else
          Delay(100); ein bischen warten
          a$+"."
        EndIf
      Wend
    EndIf
    
    search_updatefile()
    
    If CountList(updatefile$())>0
      ResetList(updatefile$())
      While NextElement(updatefile$())
        do_update(StringField(updatefile$(),1,"/"),Val(StringField(updatefile$(),2,"/")))
      Wend
      update_readfilelist()
      update_savefilelist()
      AddGadgetItem(1,0,"create: updatelist.ini",UseImage(1)):WindowEvent()
      SetGadgetText(3,"Update done.")
    Else
      create_update()
    EndIf
    DisableGadget(2,0)
    
    quit=0
    Repeat
      Select WaitWindowEvent()
        Case #pb_event_closewindow
          quit=-1
        Case #pb_event_gadget
          If EventGadgetID()=2
            quit=-1
          EndIf
      EndSelect
    Until quit
    If CountList(updatefile$())>0
      If MessageRequester("Updater","Delete old Updatefile(s)?",#PB_MessageRequester_YesNo)=#idyes
        ResetList(updatefile$())
        While NextElement(updatefile$())
          DeleteFile(StringField(updatefile$(),1,"/"))
        Wend
      EndIf
    EndIf
    FreeImage(0)
    FreeImage(1)
    CloseWindow(0)
    If autostart$<>""
      RunProgram(autostart$,"NoUpdate",".\",0)
    EndIf
  EndIf
EndIf
   


End
DataSection
  fehler:IncludeBinary "fehler.ico"
  ok:    IncludeBinary "ok.ico"
  leer:  IncludeBinary "update.ico"
EndDataSection
 
; CursorPosition=732
; ExecutableFormat=Windows
; UseIcon=F:\charas.ex\charas.updater.ico
; Executable=F:\charas.ex\Charas.Updater.exe
; EOF